********************* V-t curve simulations *********************
.SUBCKT BUFFER  1      2      3      4      5      6      7
*               d_in   pad    puref  PCLref pdref  GCLref /en
X0 2 3 4 5 6 IN_buf               $ <<<------ Change buffer name here
.ENDS
********************************************************************************
.PROTECT
.LIB  'Process.lib'  Typ
.TRAN 1.0ps 2.0ps 
********************************************************************************
.TEMP   50                        $ Temperature of typical case
*------------------------------------------------------------------------------*
.PARAM  PUref_typ  =  5.000V      $ Pullup reference voltage, typ.
.PARAM  PUref_min  =  4.750V      $ Pullup reference voltage, min.
.PARAM  PUref_max  =  5.250V      $ Pullup reference voltage, max.
.PARAM  PCLref_typ =  PUref_typ   $ Power clamp reference voltage, typ.
.PARAM  PCLref_min =  PUref_min   $ Power clamp reference voltage, min.
.PARAM  PCLref_max =  PUref_max   $ Power clamp reference voltage, max.
*------------------------------------------------------------------------------*
.PARAM  PDref_typ  =  0.000V      $ Pulldown reference voltage, typ.
.PARAM  PDref_min  =  0.000V      $ Pulldown reference voltage, min.
.PARAM  PDref_max  =  0.000V      $ Pulldown reference voltage, max.
.PARAM  GCLref_typ =  PDref_typ   $ GND clamp reference voltage, typ.
.PARAM  GCLref_min =  PDref_min   $ GND clamp reference voltage, min.
.PARAM  GCLref_max =  PDref_max   $ GND clamp reference voltage, max.
********************************************************************************
.PARAM  PD_ref     = PDref_typ    $ Reference voltages for typical case
.PARAM  GCL_ref    = GCLref_typ
.PARAM  PU_ref     = PUref_typ
.PARAM  PCL_ref    = PCLref_typ
*------------------------------------------------------------------------------*
.PARAM  Ven        = PD_ref       $ Active-low enable
*.PARAM  Ven        = PU_ref       $ Active-high enable
********************************************************************************
.PARAM  Vfx_pd_on  = PU_ref
.PARAM  Vfx_pd_off = PU_ref
.PARAM  Vfx_pu_on  = PD_ref
.PARAM  Vfx_pu_off = PD_ref
*
.PARAM  Rfx_pd_on  = 50
.PARAM  Rfx_pd_off = 50
.PARAM  Rfx_pu_on  = 50
.PARAM  Rfx_pu_off = 50
*
.PARAM  Cfx_pd_on  = 0.0pF
.PARAM  Cfx_pd_off = 0.0pF
.PARAM  Cfx_pu_on  = 0.0pF
.PARAM  Cfx_pu_off = 0.0pF
********************************************************************************
.MEASURE TRAN  Vpower           PARAM = 'PU_ref-PD_ref'
********************************************************************************
.OPTIONS BRIEF INGOLD NUMDGT=8 CO=132 ACCT=0 NOWARN ACCURATE RMAX=0.5
*.OPTIONS POST=1 POST_VERSION=9007 PROBE
.PRINT TRAN Pulldown_on  = PAR('0')
+           Pulldown_off = PAR('0')
+           Pullup_on    = PAR('0')
+           Pullup_off   = PAR('0')
********************************************************************************
Vrefpd     pdref   0  DC = PD_ref
VrefGNDcl  GCLref  0  DC = GCL_ref
Vrefpu     puref   0  DC = PU_ref
VrefPOWcl  PCLref  0  DC = PCL_ref
*
Von        Von     0  DC = Ven
Voff       Voff    0  DC = 'PU_ref-(Ven-PD_ref)'
*
Vpls_r  Pls_r  0  PWL  0.0ns PD_ref 1.0ps PU_ref 100ns PU_ref
Vpls_f  Pls_f  0  PWL  0.0ns PU_ref 1.0ps PD_ref 100ns PD_ref
******************************************************************* pull-down on
*----------------------------------------------------------------- pull-down off
*-------------------------------------------------------------------- pull-up on
*------------------------------------------------------------------- pull-up off
********************************************************************************
.UNPROTECT
********************************************************************************
.ALTER                            $ Minimum case
.PROTECT
.DEL LIB  'Process.lib'  Typ
.LIB      'Process.lib'  Slow
.TEMP   100                       $ Temperature for minimum case
.PARAM  PD_ref     = PDref_min    $ Reference voltages for minimum case
.PARAM  GCL_ref    = GCLref_min
.PARAM  PU_ref     = PUref_min
.PARAM  PCL_ref    = PCLref_min
.UNPROTECT
********************************************************************************
.ALTER                            $ Maximum case
.PROTECT
.DEL LIB  'Process.lib'  Slow
.LIB      'Process.lib'  Fast
.TEMP   0                         $ Temperature for maximum case
.PARAM  PD_ref     = PDref_max    $ Reference voltages for maximum case
.PARAM  GCL_ref    = GCLref_max
.PARAM  PU_ref     = PUref_max
.PARAM  PCL_ref    = PCLref_max
.UNPROTECT
********************************************************************************
.END
********************* I-V curve simulations *********************
.SUBCKT BUFFER  1      2      3      4      5      6      7
*               d_in   pad    puref  PCLref pdref  GCLref /en
X0 2 3 4 5 6 IN_buf               $ <<<------ Change buffer name here
.ENDS
********************************************************************************
.PROTECT
.LIB  'Process.lib'  Typ
********************************************************************************
.TEMP   50                        $ Temperature of typical case
*------------------------------------------------------------------------------*
.PARAM  Resolution =  5.0mV       $ Voltage resolution of sweep
********************************************************************************
.PARAM  PUref_typ  =  5.000V      $ Pullup reference voltage, typ.
.PARAM  PUref_min  =  4.750V      $ Pullup reference voltage, min.
.PARAM  PUref_max  =  5.250V      $ Pullup reference voltage, max.
.PARAM  PCLref_typ =  PUref_typ   $ Power clamp reference voltage, typ.
.PARAM  PCLref_min =  PUref_min   $ Power clamp reference voltage, min.
.PARAM  PCLref_max =  PUref_max   $ Power clamp reference voltage, max.
*------------------------------------------------------------------------------*
.PARAM  PDref_typ  =  0.000V      $ Pulldown reference voltage, typ.
.PARAM  PDref_min  =  0.000V      $ Pulldown reference voltage, min.
.PARAM  PDref_max  =  0.000V      $ Pulldown reference voltage, max.
.PARAM  GCLref_typ =  PDref_typ   $ GND clamp reference voltage, typ.
.PARAM  GCLref_min =  PDref_min   $ GND clamp reference voltage, min.
.PARAM  GCLref_max =  PDref_max   $ GND clamp reference voltage, max.
********************************************************************************
.PARAM  PD_ref     = PDref_typ    $ Reference voltages for typical case
.PARAM  GCL_ref    = GCLref_typ
.PARAM  PU_ref     = PUref_typ
.PARAM  PCL_ref    = PCLref_typ
*------------------------------------------------------------------------------*
.PARAM  Ven        = PD_ref       $ Active-low enable
*.PARAM  Ven        = PU_ref       $ Active-high enable
********************************************************************************
.MEASURE TRAN  Vpower        PARAM = 'PU_ref-PD_ref'
.MEASURE TRAN  GND_cl_ref    PARAM = GCL_ref
.MEASURE TRAN  POWER_cl_ref  PARAM = PCL_ref
********************************************************************************
.TRAN  Step_t  Sweep_t  START= Sweep_d
.OPTIONS BRIEF INGOLD NUMDGT=10 CO=132 ACCT=0 NOWARN ACCURATE RMAX=0.5
*.OPTIONS POST=1 POST_VERSION=9007 PROBE
.PRINT TRAN
+ V_sweep      = PAR('Resolution*(TIME-Sweep_d)/Step_t + SWstart')
+ I_pulldown   = PAR('0')
+ I_gndclamp   = I(Vgnd_clamp)
+ I_pullup     = PAR('0')
+ I_powerclamp = I(Vpower_clamp)
********************************************************************************
Vrefpd     pdref   0  DC = PD_ref
VrefGNDcl  GCLref  0  DC = GCL_ref
Vrefpu     puref   0  DC = PU_ref
VrefPOWcl  PCLref  0  DC = PCL_ref
*
Von        Von     0  DC = Ven
Voff       Voff    0  DC = 'PU_ref-(Ven-PD_ref)'
*------------------------------------------------------------------------------*
.PARAM
+ DRspan        = 'PUref_typ-PDref_typ + Resolution'
+ CLspan        = 'PCLref_typ-GCLref_typ + Resolution'
*
+ PCLstart_typ  = 'PCLref_typ - max(PUref_typ +   (DRspan) , PCLref_typ +   (CLspan))'
+ PCLend_typ    = 'PCLref_typ - min(PUref_typ - 2*(DRspan) , PCLref_typ - 2*(CLspan))'
+ GCLstart_typ  = 'min(PDref_typ -   (DRspan) , GCLref_typ -   (CLspan)) - GCLref_typ'
+ GCLend_typ    = 'max(PDref_typ + 2*(DRspan) , GCLref_typ + 2*(CLspan)) - GCLref_typ'
*
+ PCLstart_min  = 'PCLref_min - max(PUref_min +   (DRspan) , PCLref_min +   (CLspan))'
+ PCLend_min    = 'PCLref_min - min(PUref_min - 2*(DRspan) , PCLref_min - 2*(CLspan))'
+ GCLstart_min  = 'min(PDref_min -   (DRspan) , GCLref_min -   (CLspan)) - GCLref_min'
+ GCLend_min    = 'max(PDref_min + 2*(DRspan) , GCLref_min + 2*(CLspan)) - GCLref_min'
*
+ PCLstart_max  = 'PCLref_max - max(PUref_max +   (DRspan) , PCLref_max +   (CLspan))'
+ PCLend_max    = 'PCLref_max - min(PUref_max - 2*(DRspan) , PCLref_max - 2*(CLspan))'
+ GCLstart_max  = 'min(PDref_max -   (DRspan) , GCLref_max -   (CLspan)) - GCLref_max'
+ GCLend_max    = 'max(PDref_max + 2*(DRspan) , GCLref_max + 2*(CLspan)) - GCLref_max'
*
+ nPCLstart     = 'min(PCLstart_typ,min(PCLstart_min,PCLstart_max))'
+ xPCLend       = 'max(PCLend_typ  ,max(PCLend_min  ,PCLend_max))'
+ nGCLstart     = 'min(GCLstart_typ,min(GCLstart_min,GCLstart_max))'
+ xGCLend       = 'max(GCLend_typ  ,max(GCLend_min  ,GCLend_max))'
*
+ SWstart       = 'min(-1*DRspan,min(nPCLstart,nGCLstart))'
+ SWend         = 'max(   DRspan,max(xPCLend  ,xGCLend))'
*
+ Step_t        = 1.0ms                $ Step size of sweep
+ Sweep_d       = 1.0us                $ Delay before sweep begins
+ Sweep_t       = 'Sweep_d + Step_t*(SWend-SWstart)/Resolution'
********************************************************************************
Vgnd_clamp    GCLref  gnd_clamp    PWL
+  0ms                                                                             0V
+  'Sweep_d + Step_t *                      max(0,nGCLstart-SWstart) /Resolution'  '-1*nGCLstart'
+  'Sweep_d + Step_t * (xGCLend-nGCLstart + max(0,nGCLstart-SWstart))/Resolution'  '-1*xGCLend'
+  'Sweep_t + Sweep_d'                                                             0V
Vpower_clamp  PCLref  power_clamp  PWL
+  0ms                                                                             0V
+  'Sweep_d + Step_t *                      max(0,nPCLstart-SWstart) /Resolution'  'nPCLstart'
+  'Sweep_d + Step_t * (xPCLend-nPCLstart + max(0,nPCLstart-SWstart))/Resolution'  'xPCLend'
+  'Sweep_t + Sweep_d'                                                             0V
********************************************************************************
Xgnd_clamp  pdref  gnd_clamp    puref  PCLref  pdref  GCLref  Voff  BUFFER
*------------------------------------------------------------------------------*
Xpow_clamp  puref  power_clamp  puref  PCLref  pdref  GCLref  Voff  BUFFER
.UNPROTECT
********************************************************************************
.ALTER                            $ Minimum case
.PROTECT
.DEL LIB  'Process.lib'  Typ
.LIB      'Process.lib'  Slow
.TEMP   100                       $ Temperature for minimum case
.PARAM  PD_ref     = PDref_min    $ Reference voltages for minimum case
.PARAM  GCL_ref    = GCLref_min
.PARAM  PU_ref     = PUref_min
.PARAM  PCL_ref    = PCLref_min
.UNPROTECT
*********************************************************************************
.ALTER                            $ Maximum case
.PROTECT
.DEL LIB  'Process.lib'  Slow
.LIB      'Process.lib'  Fast
.TEMP   0                         $ Temperature for maximum case
.PARAM  PD_ref     = PDref_max    $ Reference voltages for maximum case
.PARAM  GCL_ref    = GCLref_max
.PARAM  PU_ref     = PUref_max
.PARAM  PCL_ref    = PCLref_max
.UNPROTECT
********************************************************************************
.END
